/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInHand;

class NightshadeSeerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("any number of black cards in your hand");

    public NightshadeSeerEffect() {
        super(Outcome.Detriment);
        this.staticText = "reveal any number of black cards in your hand. Target creature gets -X/-X until end of turn, where X is the number of cards revealed this way";
    }

    private NightshadeSeerEffect(NightshadeSeerEffect effect) {
        super((OneShotEffect)effect);
    }

    public NightshadeSeerEffect copy() {
        return new NightshadeSeerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = new RevealTargetFromHandCost(new TargetCardInHand(0, Integer.MAX_VALUE, filter));
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        int xValue = -1 * cost.getNumberRevealedCards();
        game.addEffect((ContinuousEffect)new BoostTargetEffect(xValue, xValue, Duration.EndOfTurn), source);
        return true;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
    }
}

