/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class NihiloorControlEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("untapped creatured you control");

    NihiloorControlEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, tap up to one untapped creature you control. When you do, gain control of target creature that player controls with power less than or equal to the tapped creature's power for as long as you control {this}";
    }

    private NihiloorControlEffect(NihiloorControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public NihiloorControlEffect copy() {
        return new NihiloorControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)filter, true);
            target.withChooseHint("tapping a creature controlled by " + opponent.getName());
            controller.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null || !permanent.tap(source, game)) continue;
            FilterPermanent filter2 = new FilterPermanent("creature controlled by " + opponent.getName() + " with power " + permanent.getPower().getValue() + " or less");
            filter2.add((Predicate)new NihiloorPredicate(permanent, playerId));
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new GainControlTargetEffect(Duration.WhileControlled, true), false, "gain control of target creature that player controls with power less than or equal to the tapped creature's power for as long as you control {this}");
            ability.addTarget((Target)new TargetPermanent(filter2));
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }

    private static final class NihiloorPredicate
    implements Predicate<Permanent> {
        private final Permanent permanent;
        private final UUID playerId;

        private NihiloorPredicate(Permanent permanent, UUID playerId) {
            this.permanent = permanent;
            this.playerId = playerId;
        }

        public boolean apply(Permanent input, Game game) {
            return input.isControlledBy(this.playerId) && input.isCreature(game) && input.getPower().getValue() <= this.permanent.getPower().getValue();
        }
    }
}

