/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

enum NikoDefiesDestinyValue implements DynamicValue
{
    ONE(1),
    TWO(2);

    private final int amount;

    private NikoDefiesDestinyValue(int amount) {
        this.amount = amount;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller == null) {
            return 0;
        }
        Collection exileZones = game.getState().getExile().getExileZones();
        CardsImpl cardsForetoldInExileZones = new CardsImpl();
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new OwnerIdPredicate(controller.getId()));
        for (ExileZone exile : exileZones) {
            for (Card card : exile.getCards(filter, game)) {
                UUID exileId = CardUtil.getExileZoneId((String)(card.getId().toString() + "foretellAbility"), (Game)game);
                if (exileId == null || game.getState().getExile().getExileZone(exileId) == null) continue;
                cardsForetoldInExileZones.add(card);
            }
        }
        return this.amount * cardsForetoldInExileZones.size();
    }

    public DynamicValue copy() {
        return this;
    }

    public String getMessage() {
        return "foretold card you own in exile";
    }

    public String toString() {
        return "" + this.amount;
    }
}

