/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class NikoLightOfHopeEffect
extends OneShotEffect {
    NikoLightOfHopeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target nonlegendary creature you control. Shards you control become copies of it until the next end step. Return it to the battlefield under its owner's control at the beginning of the next end step.";
    }

    private NikoLightOfHopeEffect(NikoLightOfHopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public NikoLightOfHopeEffect copy() {
        return new NikoLightOfHopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || controller == null || !permanent.moveToExile(source.getSourceId(), "Niko, Light of Hope", source, game)) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("shards");
        filter.add((Predicate)SubType.SHARD.getPredicate());
        for (Permanent copyTo : game.getBattlefield().getAllActivePermanents(filter, controller.getId(), game)) {
            game.copyPermanent(Duration.UntilNextEndStep, permanent, copyTo.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        ExileZone exile = game.getExile().getExileZone(source.getSourceId());
        if (exile == null || exile.isEmpty()) {
            return true;
        }
        Card card = game.getCard(permanent.getId());
        if (card == null) {
            return true;
        }
        ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }
}

