/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.n.NimDeathmantleEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NimDeathmantleTriggeredAbility
extends TriggeredAbilityImpl {
    NimDeathmantleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new NimDeathmantleEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private NimDeathmantleTriggeredAbility(NimDeathmantleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NimDeathmantleTriggeredAbility copy() {
        return new NimDeathmantleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Permanent permanent = zEvent.getTarget();
        if (permanent != null && permanent.isOwnedBy(this.controllerId) && zEvent.isDiesEvent() && !(permanent instanceof PermanentToken) && permanent.isCreature(game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), permanent.getZoneChangeCounter(game) + 1));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a nontoken creature is put into your graveyard from the battlefield, you may pay {4}. If you do, return that card to the battlefield and attach {this} to it.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

