/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class NineFingersKeeneEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Gate card");
    private static final FilterPermanent filter2 = new FilterControlledPermanent(SubType.GATE);

    NineFingersKeeneEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top nine cards of your library. You may put a Gate card from among them onto the battlefield. Then if you control nine or more Gates, put the rest into your hand. Otherwise, put the rest on the bottom of your library in a random order";
    }

    private NineFingersKeeneEffect(NineFingersKeeneEffect effect) {
        super((OneShotEffect)effect);
    }

    public NineFingersKeeneEffect copy() {
        return new NineFingersKeeneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 9));
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        if (game.getBattlefield().count(filter2, source.getControllerId(), source, game) >= 9) {
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        } else {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.GATE.getPredicate());
    }
}

