/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NineLivesStateTriggeredAbility
extends StateTriggeredAbility {
    public NineLivesStateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileSourceEffect());
    }

    private NineLivesStateTriggeredAbility(NineLivesStateTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public NineLivesStateTriggeredAbility copy() {
        return new NineLivesStateTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.INCARNATION) >= 9;
    }

    public String getRule() {
        return "When there are nine or more incarnation counters on {this}, exile it.";
    }
}

