/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NinjasBladesEffect
extends OneShotEffect {
    NinjasBladesEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then discard a card. That player loses life equal to the discarded card's mana value";
    }

    private NinjasBladesEffect(NinjasBladesEffect effect) {
        super((OneShotEffect)effect);
    }

    public NinjasBladesEffect copy() {
        return new NinjasBladesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        Card card = controller.discardOne(false, false, source, game);
        if (card == null || card.getManaValue() < 1) {
            return true;
        }
        Optional.ofNullable(this.getTargetPointer().getFirst(game, source)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.loseLife(card.getManaValue(), game, source, false));
        return true;
    }
}

