/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.LinkedHashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;

class NissaNaturesArtisanEffect
extends OneShotEffect {
    NissaNaturesArtisanEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reveal the top two cards of your library. Put all land cards from among them onto the battlefield and the rest into your hand";
    }

    private NissaNaturesArtisanEffect(NissaNaturesArtisanEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 2));
        if (!cards.isEmpty()) {
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            LinkedHashSet<Card> toBattlefield = new LinkedHashSet<Card>();
            for (Card card : cards.getCards((FilterCard)new FilterLandCard(), source.getControllerId(), source, game)) {
                cards.remove(card);
                toBattlefield.add(card);
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            controller.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        return true;
    }

    public NissaNaturesArtisanEffect copy() {
        return new NissaNaturesArtisanEffect(this);
    }
}

