/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;

class NissaOfShadowedBoughsLandEffect
extends OneShotEffect {
    NissaOfShadowedBoughsLandEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may have it become a 3/3 Elemental creature with haste and menace until end of turn. It's still a land.";
    }

    private NissaOfShadowedBoughsLandEffect(NissaOfShadowedBoughsLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaOfShadowedBoughsLandEffect copy() {
        return new NissaOfShadowedBoughsLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.chooseUse(Outcome.BecomeCreature, "Have it become a creature?", source, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BecomesCreatureTargetEffect((Token)new CreatureToken(3, 3, "", new SubType[]{SubType.ELEMENTAL}).withAbility((Ability)HasteAbility.getInstance()).withAbility((Ability)new MenaceAbility()), false, true, Duration.EndOfTurn), source);
        return true;
    }
}

