/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NissaSageAnimistMinusAnimateEffect
extends OneShotEffect {
    NissaSageAnimistMinusAnimateEffect() {
        super(Outcome.BecomeCreature);
        this.staticText = "They become 6/6 Elemental creatures. They're still lands";
    }

    private NissaSageAnimistMinusAnimateEffect(NissaSageAnimistMinusAnimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaSageAnimistMinusAnimateEffect copy() {
        return new NissaSageAnimistMinusAnimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            BecomesCreatureTargetEffect effect = new BecomesCreatureTargetEffect((Token)new CreatureToken(6, 6, "", new SubType[]{SubType.ELEMENTAL}), false, true, Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

