/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class NissaSageAnimistPlusOneEffect
extends OneShotEffect {
    NissaSageAnimistPlusOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top card of your library. If it's a land card, put it onto the battlefield. Otherwise, put it into your hand.";
    }

    private NissaSageAnimistPlusOneEffect(NissaSageAnimistPlusOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaSageAnimistPlusOneEffect copy() {
        return new NissaSageAnimistPlusOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null && controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card == null) {
                return false;
            }
            controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
            Zone targetZone = Zone.HAND;
            if (card.isLand(game)) {
                targetZone = Zone.BATTLEFIELD;
            }
            return controller.moveCards(card, targetZone, source, game);
        }
        return true;
    }
}

