/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NissasDefeatEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public NissasDefeatEffect() {
        super(Outcome.Damage);
        this.staticText = "Destroy target Forest, green enchantment, or green planeswalker. If that permanent was a Nissa planeswalker, draw a card.";
    }

    private NissasDefeatEffect(NissasDefeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissasDefeatEffect copy() {
        return new NissasDefeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null) {
            permanent.destroy(source, game, false);
            if (filter.match((Object)permanent, game) && controller != null) {
                controller.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CardType.PLANESWALKER.getPredicate());
        filter.add((Predicate)SubType.NISSA.getPredicate());
    }
}

