/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.n.NissasEncouragementTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class NissasEncouragementEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card named Forest, a card named Brambleweft Behemoth, and a card named Nissa, Genesis Mage");
    private static final FilterCard filterGY = new FilterCard();

    public NissasEncouragementEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library and graveyard for a card named Forest, a card named Brambleweft Behemoth, and a card named Nissa, Genesis Mage. Reveal those cards, put them into your hand, then shuffle.";
    }

    private NissasEncouragementEffect(NissasEncouragementEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissasEncouragementEffect copy() {
        return new NissasEncouragementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (player == null || sourceCard == null) {
            return false;
        }
        NissasEncouragementTarget target = new NissasEncouragementTarget(filter);
        if (player.searchLibrary((TargetCardInLibrary)target, source, game)) {
            boolean searchGY = target.getTargets().size() < 3;
            HashMap<String, Integer> foundCards = new HashMap<String, Integer>();
            foundCards.put("Forest", 0);
            foundCards.put("Brambleweft Behemoth", 0);
            foundCards.put("Nissa, Genesis Mage", 0);
            CardsImpl cards = new CardsImpl();
            if (!target.getTargets().isEmpty()) {
                for (UUID cardId : target.getTargets()) {
                    Card card = player.getLibrary().remove(cardId, game);
                    if (card == null) continue;
                    cards.add(card);
                    foundCards.put(card.getName(), 1);
                }
            }
            if (searchGY) {
                for (String name : foundCards.keySet()) {
                    if ((Integer)foundCards.get(name) == 1) continue;
                    FilterCard namedFilterGY = filterGY.copy();
                    namedFilterGY.add((Predicate)new NamePredicate(name));
                    if (player.getGraveyard().count(namedFilterGY, game) <= 0) continue;
                    TargetCard targetGY = new TargetCard(0, 1, Zone.GRAVEYARD, namedFilterGY);
                    if (!player.choose(Outcome.ReturnToHand, (Cards)player.getGraveyard(), targetGY, source, game)) continue;
                    for (UUID cardIdGY : targetGY.getTargets()) {
                        Card cardGY = player.getGraveyard().get(cardIdGY, game);
                        cards.add(cardGY);
                    }
                }
            }
            if (!cards.isEmpty()) {
                player.revealCards(sourceCard.getIdName(), (Cards)cards, game);
                player.moveCards((Cards)cards, Zone.HAND, source, game);
                player.shuffleLibrary(source, game);
                return true;
            }
        }
        player.shuffleLibrary(source, game);
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{new NamePredicate("Forest"), new NamePredicate("Brambleweft Behemoth"), new NamePredicate("Nissa, Genesis Mage")}));
    }
}

