/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NissasJudgmentEffect
extends OneShotEffect {
    NissasJudgmentEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose up to one target creature an opponent controls. Each creature you control with a +1/+1 counter on it deals damage equal to its power to that creature";
        this.concatPrefix = "<br>";
    }

    private NissasJudgmentEffect(NissasJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissasJudgmentEffect copy() {
        return new NissasJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_P1P1, controller.getId(), game)) {
                    if (permanent.getPower().getValue() <= 0) continue;
                    targetCreature.damage(permanent.getPower().getValue(), permanent.getId(), source, game, false, true);
                }
            }
            return true;
        }
        return false;
    }
}

