/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.JumpStartAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class NivMizzetSupremeEffect
extends ContinuousEffectImpl {
    NivMizzetSupremeEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each instant and sorcery card in your graveyard that's exactly two colors has jump-start";
    }

    private NivMizzetSupremeEffect(NivMizzetSupremeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getGraveyard().getCards(game)) {
            if (!card.isInstantOrSorcery(game) || card.getColor(game).getColorCount() != 2) continue;
            game.getState().addOtherAbility(card, (Ability)new JumpStartAbility(card));
        }
        return true;
    }

    public NivMizzetSupremeEffect copy() {
        return new NivMizzetSupremeEffect(this);
    }
}

