/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.Filter;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class NobleHeritageEffect
extends OneShotEffect {
    NobleHeritageEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may put two +1/+1 counters on a creature they control. If a player does, creatures that player controls can't attack you or planeswalkers you control until your next turn";
    }

    private NobleHeritageEffect(NobleHeritageEffect effect) {
        super((OneShotEffect)effect);
    }

    public NobleHeritageEffect copy() {
        return new NobleHeritageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList players = new ArrayList();
        ArrayList creatures = new ArrayList();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(this.outcome, "Put two +1/+1 counters on a creature you control?", source, game)) continue;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, 1);
            target.withNotTarget(true);
            target.withChooseHint("to add counters to");
            player.choose(this.outcome, (Target)target, source, game);
            Optional.ofNullable(target).map(Target::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> {
                creatures.add(permanent.getId());
                players.add(player.getId());
            });
        }
        for (UUID creatureId : creatures) {
            Permanent creature = game.getPermanent(creatureId);
            if (creature == null) continue;
            creature.addCounters(CounterType.P1P1.createInstance(2), creature.getControllerId(), source, game);
        }
        for (UUID playerId : players) {
            if (source.isControlledBy(playerId)) continue;
            FilterPlayer filter = new FilterPlayer();
            filter.add((Predicate)new PlayerIdPredicate(playerId));
            game.addEffect((ContinuousEffect)new GainAbilityControllerEffect((Ability)new ProtectionAbility((Filter)filter), Duration.UntilYourNextTurn), source);
        }
        return true;
    }
}

