/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.TriggeredAbilityImpl;
import mage.cards.n.NobleHeritageEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NobleHeritageTriggeredAbility
extends TriggeredAbilityImpl {
    public NobleHeritageTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private NobleHeritageTriggeredAbility(NobleHeritageTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NobleHeritageTriggeredAbility copy() {
        return new NobleHeritageTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        this.getEffects().clear();
        boolean result = event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD ? event.getTargetId().equals(this.getSourceId()) : event.getPlayerId().equals(this.getControllerId());
        if (result) {
            Permanent enchantment = game.getPermanentOrLKIBattlefield(this.getSourceId());
            if (enchantment != null) {
                NobleHeritageEffect effect = new NobleHeritageEffect();
                this.getEffects().add((Object)effect);
            } else {
                result = false;
            }
        }
        return result;
    }

    public String getRule() {
        return "When this creature enters the battlefield and at the beginning of your upkeep, each player may put two +1/+1 counters on a creature they control. For each opponent who does, you gain protection from that player until your next turn.";
    }
}

