/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NobleStandAbility
extends TriggeredAbilityImpl {
    NobleStandAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(2));
        this.setTriggerPhrase("Whenever a creature you control blocks, ");
    }

    private NobleStandAbility(NobleStandAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && StaticFilters.FILTER_CONTROLLED_CREATURE.match(permanent, this.controllerId, (Ability)this, game);
    }

    public NobleStandAbility copy() {
        return new NobleStandAbility(this);
    }
}

