/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NovijenHeartOfProgressEffect
extends OneShotEffect {
    NovijenHeartOfProgressEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put a +1/+1 counter on each creature that entered the battlefield this turn";
    }

    private NovijenHeartOfProgressEffect(NovijenHeartOfProgressEffect effect) {
        super((OneShotEffect)effect);
    }

    public NovijenHeartOfProgressEffect copy() {
        return new NovijenHeartOfProgressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                if (permanent.getTurnsOnBattlefield() != 0) continue;
                permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " puts a +1/+1 counter on " + permanent.getLogName());
            }
            return true;
        }
        return false;
    }
}

