/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.abilities.keyword.WardAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NowhereToRunWardEffect
extends ContinuousRuleModifyingEffectImpl {
    NowhereToRunWardEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Ward abilities of those creatures don't trigger.";
    }

    private NowhereToRunWardEffect(NowhereToRunWardEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.NUMBER_OF_TRIGGERS);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        if (!game.getOpponents(source.getControllerId()).contains(permanent.getControllerId())) {
            return false;
        }
        return this.getValue("targetAbility") instanceof WardAbility;
    }

    public ContinuousEffect copy() {
        return new NowhereToRunWardEffect(this);
    }
}

