/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class NoxiousVaporsEffect
extends OneShotEffect {
    private static final FilterNonlandCard filter = new FilterNonlandCard();

    NoxiousVaporsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player reveals their hand, chooses one card of each color from it, then discards all other nonland cards";
    }

    private NoxiousVaporsEffect(NoxiousVaporsEffect effect) {
        super((OneShotEffect)effect);
    }

    public NoxiousVaporsEffect copy() {
        return new NoxiousVaporsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            player.revealCards(player.getName() + "'s hand", player.getHand(), game);
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            HashSet<Card> chosenCards = new HashSet<Card>();
            this.chooseCardForColor(ObjectColor.WHITE, chosenCards, player, game, source);
            this.chooseCardForColor(ObjectColor.BLUE, chosenCards, player, game, source);
            this.chooseCardForColor(ObjectColor.BLACK, chosenCards, player, game, source);
            this.chooseCardForColor(ObjectColor.RED, chosenCards, player, game, source);
            this.chooseCardForColor(ObjectColor.GREEN, chosenCards, player, game, source);
            chosenCards.addAll(player.getHand().getCards((FilterCard)StaticFilters.FILTER_CARD_LAND, game));
            Cards cards = player.getHand().copy();
            cards.removeIf(chosenCards.stream().map(MageItem::getId).collect(Collectors.toSet())::contains);
            player.discard(cards, false, source, game);
        }
        return true;
    }

    private void chooseCardForColor(ObjectColor color, Set<Card> chosenCards, Player player, Game game, Ability source) {
        Card card;
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ColorPredicate(color));
        TargetCardInHand target = new TargetCardInHand(filter);
        if (player.choose(Outcome.Benefit, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            chosenCards.add(card);
        }
    }
}

