/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.DistributeCountersEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetPermanentAmount;

class NumaJoragaChieftainEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.ELF, "Elves");

    NumaJoragaChieftainEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}{X}. When you do, distribute X +1/+1 counters among any number of target Elves";
    }

    private NumaJoragaChieftainEffect(NumaJoragaChieftainEffect effect) {
        super((OneShotEffect)effect);
    }

    public NumaJoragaChieftainEffect copy() {
        return new NumaJoragaChieftainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{X}{X}");
        if (!player.chooseUse(Outcome.BoostCreature, "Pay " + cost.getText() + "?", source, game)) {
            return false;
        }
        int costX = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to distribute counters)", game, source, true);
        cost.add((Object)new GenericManaCost(2 * costX));
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DistributeCountersEffect(), false, "distribute " + costX + " +1/+1 counters among any number of target Elves");
        ability.addTarget((Target)new TargetPermanentAmount(costX, 0, filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

