/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NyleasColossusEffect
extends OneShotEffect {
    NyleasColossusEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "double target creature's power and toughness until end of turn";
    }

    private NyleasColossusEffect(NyleasColossusEffect effect) {
        super((OneShotEffect)effect);
    }

    public NyleasColossusEffect copy() {
        return new NyleasColossusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        int toughness = permanent.getToughness().getValue();
        game.addEffect((ContinuousEffect)new BoostTargetEffect(power, toughness, Duration.EndOfTurn), source);
        return true;
    }
}

