/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class OathOfMagesEffect
extends OneShotEffect {
    OathOfMagesEffect() {
        super(Outcome.Damage);
        this.staticText = "that player chooses target player who has more life than they do and is their opponent. The first player may have {this} deal 1 damage to the second player";
    }

    private OathOfMagesEffect(OathOfMagesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player firstPlayer = game.getPlayer(game.getActivePlayerId());
        Player secondPlayer = game.getPlayer(source.getFirstTarget());
        if (sourceObject == null || firstPlayer == null) {
            return false;
        }
        if (firstPlayer.chooseUse(Outcome.Benefit, "Deal one damage to " + secondPlayer.getLogName() + "?", source, game)) {
            secondPlayer.damage(1, source.getSourceId(), source, game);
        }
        return true;
    }

    public OathOfMagesEffect copy() {
        return new OathOfMagesEffect(this);
    }
}

