/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum OathkeeperEquippedSamuraiCondition implements Condition
{
    instance;

    private static final FilterCreaturePermanent filter;

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            permanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (permanent != null) {
            Permanent attachedTo = null;
            if (permanent.getAttachedTo() != null && (attachedTo = game.getPermanent(permanent.getAttachedTo())) == null) {
                attachedTo = (Permanent)game.getLastKnownInformation(permanent.getAttachedTo(), Zone.BATTLEFIELD);
            }
            if (attachedTo == null) {
                for (Effect effect : source.getEffects()) {
                    attachedTo = (Permanent)effect.getValue("attachedTo");
                }
            }
            if (attachedTo != null) {
                return filter.match(attachedTo, attachedTo.getControllerId(), source, game);
            }
        }
        return false;
    }

    static {
        filter = new FilterCreaturePermanent("it's a Samurai card");
        filter.add((Predicate)SubType.SAMURAI.getPredicate());
    }
}

