/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OblationEffect
extends OneShotEffect {
    OblationEffect() {
        super(Outcome.Removal);
        this.staticText = "The owner of target nonland permanent shuffles it into their library, then draws two cards";
    }

    private OblationEffect(OblationEffect effect) {
        super((OneShotEffect)effect);
    }

    public OblationEffect copy() {
        return new OblationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && (player = game.getPlayer(permanent.getOwnerId())) != null) {
            player.moveCardToLibraryWithInfo((Card)permanent, source, game, Zone.BATTLEFIELD, true, true);
            player.shuffleLibrary(source, game);
            game.processAction();
            player.drawCards(2, source, game);
            return true;
        }
        return false;
    }
}

