/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class OblivionSowerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterLandCard();

    OblivionSowerEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = ", then you may put any number of land cards that player owns from exile onto the battlefield under your control";
    }

    private OblivionSowerEffect(OblivionSowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public OblivionSowerEffect copy() {
        return new OblivionSowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPlayer == null) {
            return false;
        }
        CardsImpl exiledLands = new CardsImpl(game.getExile().getCardsOwned(filter, targetPlayer.getId(), source, game));
        if (!exiledLands.isEmpty() && controller.chooseUse(this.outcome, "Put lands into play?", source, game)) {
            FilterCard filterToPlay = new FilterCard("land" + (exiledLands.size() > 1 ? "s" : "") + " from exile owned by " + targetPlayer.getName() + " to put into play under your control");
            TargetCard targetCards = new TargetCard(0, exiledLands.size(), Zone.EXILED, filterToPlay);
            if (controller.chooseTarget(this.outcome, (Cards)exiledLands, targetCards, source, game)) {
                controller.moveCards((Cards)new CardsImpl((Collection)targetCards.getTargets()), Zone.BATTLEFIELD, source, game);
            }
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)FaceDownPredicate.instance));
    }
}

