/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OblivionStoneEffect
extends OneShotEffect {
    OblivionStoneEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy each nonland permanent without a fate counter on it, then remove all fate counters from all permanents";
    }

    private OblivionStoneEffect(OblivionStoneEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            if (permanent.isLand(game) || permanent.getCounters(game).containsKey(CounterType.FATE)) continue;
            permanent.destroy(source, game, false);
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            permanent.removeAllCounters(CounterType.FATE.getName(), source, game);
        }
        return true;
    }

    public OblivionStoneEffect copy() {
        return new OblivionStoneEffect(this);
    }
}

