/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ObliviousBookwormWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    ObliviousBookwormWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
                if (permanent != null && permanent.isFaceDown(game)) {
                    this.set.add(permanent.getControllerId());
                }
                return;
            }
            case TURNED_FACE_UP: {
                this.set.add(event.getPlayerId());
            }
        }
    }

    public void reset() {
        this.set.clear();
        super.reset();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((ObliviousBookwormWatcher)game.getState().getWatcher(ObliviousBookwormWatcher.class)).set.contains(source.getControllerId());
    }
}

