/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ObzedatGhostCouncilReturnEffect
extends OneShotEffect {
    private final Card card;

    ObzedatGhostCouncilReturnEffect(Card card) {
        super(Outcome.Benefit);
        this.card = card;
    }

    private ObzedatGhostCouncilReturnEffect(ObzedatGhostCouncilReturnEffect effect) {
        super((OneShotEffect)effect);
        this.card = effect.card;
    }

    public ObzedatGhostCouncilReturnEffect copy() {
        return new ObzedatGhostCouncilReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (this.card == null) {
            return false;
        }
        Player owner = game.getPlayer(this.card.getOwnerId());
        if (owner == null || !owner.moveCards(this.card, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.WhileOnBattlefield), source);
        return true;
    }
}

