/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class OddsEffect
extends OneShotEffect {
    OddsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Flip a coin. If it comes up heads, counter target instant or sorcery spell. If it comes up tails, copy that spell and you may choose new targets for the copy";
    }

    private OddsEffect(OddsEffect effect) {
        super((OneShotEffect)effect);
    }

    public OddsEffect copy() {
        return new OddsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.flipCoin(source, game, false)) {
                game.informPlayers("Odds: Spell countered");
                return game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
            }
            game.informPlayers("Odds: Spell will be copied");
            return new CopyTargetStackObjectEffect().apply(game, source);
        }
        return false;
    }
}

