/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.ChooseBlockersEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;
import mage.watchers.common.ControlCombatRedundancyWatcher;

class OdricMasterTacticianTriggeredAbility
extends TriggeredAbilityImpl {
    public OdricMasterTacticianTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ChooseBlockersEffect(Duration.EndOfCombat));
        this.addWatcher((Watcher)new ControlCombatRedundancyWatcher());
        this.setTriggerPhrase("Whenever {this} and at least three other creatures attack, ");
    }

    private OdricMasterTacticianTriggeredAbility(OdricMasterTacticianTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OdricMasterTacticianTriggeredAbility copy() {
        return new OdricMasterTacticianTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getCombat().getAttackers().size() >= 4 && game.getCombat().getAttackers().contains(this.sourceId);
    }
}

