/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OffspringsRevengeEffect
extends OneShotEffect {
    OffspringsRevengeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target red, white, or black creature card from your graveyard. Create a token that's a copy of that card, except it's 1/1. It gains haste until your next turn.";
    }

    private OffspringsRevengeEffect(OffspringsRevengeEffect effect) {
        super((OneShotEffect)effect);
    }

    public OffspringsRevengeEffect copy() {
        return new OffspringsRevengeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, false, false, null, 1, 1, false);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), card.getZoneChangeCounter(game) + 1));
        player.moveCards(card, Zone.EXILED, source, game);
        effect.apply(game, source);
        effect.getAddedPermanents().stream().forEach(permanent -> {
            GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.UntilYourNextTurn);
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)continuousEffect, source);
        });
        return true;
    }
}

