/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.o.OgreHeadHelmEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OgreHeadHelmTriggeredAbility
extends TriggeredAbilityImpl {
    OgreHeadHelmTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new OgreHeadHelmEffect());
    }

    private OgreHeadHelmTriggeredAbility(OgreHeadHelmTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OgreHeadHelmTriggeredAbility copy() {
        return new OgreHeadHelmTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (this.getSourceId().equals(event.getSourceId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            return true;
        }
        Permanent permanent = this.getSourcePermanentOrLKI(game);
        if (permanent != null && event.getSourceId().equals(permanent.getAttachedTo())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} or equipped creature deals combat damage to a player, you may sacrifice it. If you do, discard your hand, then draw three cards.";
    }
}

