/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ReboundAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class OjerPakpatiqDeepestEpochGainReboundEffect
extends ContinuousEffectImpl {
    OjerPakpatiqDeepestEpochGainReboundEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "it gains rebound";
    }

    private OjerPakpatiqDeepestEpochGainReboundEffect(OjerPakpatiqDeepestEpochGainReboundEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public OjerPakpatiqDeepestEpochGainReboundEffect copy() {
        return new OjerPakpatiqDeepestEpochGainReboundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            this.discard();
            return false;
        }
        Card card = spell.getCard();
        if (card == null) {
            return false;
        }
        this.addReboundAbility(card, game);
        return true;
    }

    private void addReboundAbility(Card card, Game game) {
        boolean found = false;
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof ReboundAbility)) continue;
            found = true;
            break;
        }
        if (!found) {
            ReboundAbility ability = new ReboundAbility();
            game.getState().addOtherAbility(card, (Ability)ability);
        }
    }
}

