/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.condition.common.ControlArtifactAndEnchantmentCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class OkibaSalvageEffect
extends OneShotEffect {
    OkibaSalvageEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature or Vehicle card from your graveyard to the battlefield. Then put two +1/+1 counters on that permanent if you control an artifact and an enchantment";
    }

    private OkibaSalvageEffect(OkibaSalvageEffect effect) {
        super((OneShotEffect)effect);
    }

    public OkibaSalvageEffect copy() {
        return new OkibaSalvageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null && ControlArtifactAndEnchantmentCondition.instance.apply(game, source)) {
            permanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
        }
        return true;
    }
}

