/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OkoThiefOfCrownsEffect
extends ContinuousEffectImpl {
    OkoThiefOfCrownsEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "target artifact or creature loses all abilities and becomes a green Elk creature with base power and toughness 3/3";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private OkoThiefOfCrownsEffect(OkoThiefOfCrownsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public OkoThiefOfCrownsEffect copy() {
        return new OkoThiefOfCrownsEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.removeAllSubTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.addSubType(game, new SubType[]{SubType.ELK});
                return true;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setWhite(false);
                permanent.getColor(game).setBlue(false);
                permanent.getColor(game).setBlack(false);
                permanent.getColor(game).setRed(false);
                permanent.getColor(game).setGreen(true);
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(3);
                permanent.getToughness().setModifiedBaseValue(3);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case ColorChangingEffects_5: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

