/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OldManOfTheSeaEffect
extends ContinuousEffectImpl {
    OldManOfTheSeaEffect() {
        super(Duration.Custom, Outcome.GainControl);
        this.staticText = "gain control of target creature with power less than or equal to {this}'s power for as long as {this} remains tapped and that creature's power remains less than or equal to {this}'s power";
    }

    private OldManOfTheSeaEffect(OldManOfTheSeaEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public OldManOfTheSeaEffect copy() {
        return new OldManOfTheSeaEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || permanent == null || !sourcePermanent.isTapped()) {
            this.discard();
            return false;
        }
        switch (layer) {
            case ControlChangingEffects_2: {
                permanent.changeControllerId(source.getControllerId(), game, source);
                return true;
            }
            case RulesEffects: {
                if (permanent.getPower().getValue() <= sourcePermanent.getPower().getValue()) break;
                this.discard();
                return false;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.ControlChangingEffects_2 || layer == Layer.RulesEffects;
    }
}

