/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.BloodToken;
import mage.game.permanent.token.InsectToken;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class OldRutsteinEffect
extends OneShotEffect {
    OldRutsteinEffect() {
        super(Outcome.Benefit);
    }

    private OldRutsteinEffect(OldRutsteinEffect effect) {
        super((OneShotEffect)effect);
    }

    public OldRutsteinEffect copy() {
        return new OldRutsteinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(1, source, game);
        if (cards.getCards(game).stream().anyMatch(card -> card.isLand(game))) {
            new TreasureToken().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        if (cards.getCards(game).stream().anyMatch(card -> card.isCreature(game))) {
            new InsectToken().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        if (cards.getCards(game).stream().anyMatch(card -> !card.isCreature(game) && !card.isLand(game))) {
            new BloodToken().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        return true;
    }
}

