/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class OldStickfingersEffect
extends OneShotEffect {
    OldStickfingersEffect() {
        super(Outcome.Discard);
        this.staticText = "reveal cards from the top of your library until you reveal X creature cards. Put all creature cards revealed this way into your graveyard, then put the rest on the bottom of your library in a random order";
    }

    private OldStickfingersEffect(OldStickfingersEffect effect) {
        super((OneShotEffect)effect);
    }

    public OldStickfingersEffect copy() {
        return new OldStickfingersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object obj = this.getValue("sourceCastSpellAbility");
        if (!(obj instanceof SpellAbility)) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)((SpellAbility)obj), (String)"X", (Object)0);
        if (xValue < 1) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl revealed = new CardsImpl();
        CardsImpl otherCards = new CardsImpl();
        LinkedHashSet<Card> creatureCards = new LinkedHashSet<Card>();
        for (Card card : controller.getLibrary().getCards(game)) {
            revealed.add(card);
            if (card.isCreature(game)) {
                creatureCards.add(card);
                if (creatureCards.size() != xValue) continue;
                break;
            }
            otherCards.add(card);
        }
        controller.revealCards(source, (Cards)revealed, game);
        controller.moveCards(creatureCards, Zone.GRAVEYARD, source, game);
        controller.putCardsOnBottomOfLibrary((Cards)otherCards, game, source, false);
        return true;
    }
}

