/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OmenOfFireEffect
extends OneShotEffect {
    private static final FilterPermanent filterWhite1 = new FilterPermanent("Plains or white permanent");
    private static final FilterPermanent filterWhite2;

    public OmenOfFireEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player sacrifices a Plains or a white permanent for each white permanent they control";
    }

    private OmenOfFireEffect(OmenOfFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public OmenOfFireEffect copy() {
        return new OmenOfFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int whitePermanents;
                Player player = game.getPlayer(playerId);
                if (player == null || (whitePermanents = game.getBattlefield().countAll(filterWhite2, playerId, game)) <= 0) continue;
                SacrificeEffect effect = new SacrificeEffect(filterWhite1, whitePermanents, "");
                effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }

    static {
        filterWhite1.add(Predicates.or((Predicate)SubType.PLAINS.getPredicate(), (Predicate)new ColorPredicate(ObjectColor.WHITE)));
        filterWhite2 = new FilterPermanent("white permanent");
        filterWhite2.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

