/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.OminousRoostBirdToken;
import mage.game.permanent.token.Token;

class OminousRoostTriggeredAbility
extends TriggeredAbilityImpl {
    OminousRoostTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new OminousRoostBirdToken()));
    }

    private OminousRoostTriggeredAbility(OminousRoostTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: {
                if (event.getPlayerId().equals(this.controllerId) && event.getZone() == Zone.GRAVEYARD) {
                    return true;
                }
            }
            case ENTERS_THE_BATTLEFIELD: {
                return event.getTargetId().equals(this.getSourceId());
            }
        }
        return false;
    }

    public String getRule() {
        return "When {this} enters or whenever you cast a spell from your graveyard, create a 1/1 blue Bird creature token with flying and \"This creature can block only creatures with flying.\"";
    }

    public OminousRoostTriggeredAbility copy() {
        return new OminousRoostTriggeredAbility(this);
    }
}

