/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OnceMoreWithFeelingEffect
extends OneShotEffect {
    OnceMoreWithFeelingEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all permanents and all cards from all graveyards. Each player shuffles their hand into their library";
    }

    private OnceMoreWithFeelingEffect(OnceMoreWithFeelingEffect effect) {
        super((OneShotEffect)effect);
    }

    public OnceMoreWithFeelingEffect copy() {
        return new OnceMoreWithFeelingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            permanent.moveToExile(null, "", source, game);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (UUID cid : player.getGraveyard().copy()) {
                Card c = game.getCard(cid);
                if (c == null) continue;
                c.moveToExile(null, null, source, game);
            }
            player.moveCards(player.getHand(), Zone.LIBRARY, source, game);
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

