/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.OonaQueenFaerieRogueToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.CardUtil;

class OonaQueenOfTheFaeEffect
extends OneShotEffect {
    OonaQueenOfTheFaeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose a color. Target opponent exiles the top X cards of their library. For each card of the chosen color exiled this way, create a 1/1 blue and black Faerie Rogue creature token with flying";
    }

    private OonaQueenOfTheFaeEffect(OonaQueenOfTheFaeEffect effect) {
        super((OneShotEffect)effect);
    }

    public OonaQueenOfTheFaeEffect copy() {
        return new OonaQueenOfTheFaeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        ChoiceColor choice = new ChoiceColor();
        if (controller == null || opponent == null || !controller.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        int cardsWithColor = 0;
        CardsImpl cardsToExile = new CardsImpl();
        cardsToExile.addAllCards((Collection)opponent.getLibrary().getTopCards(game, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        for (Card card : cardsToExile.getCards(game)) {
            if (card == null || !card.getColor(game).contains(choice.getColor())) continue;
            ++cardsWithColor;
        }
        controller.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
        if (cardsWithColor > 0) {
            new CreateTokenEffect((Token)new OonaQueenFaerieRogueToken(), cardsWithColor).apply(game, source);
        }
        game.informPlayers("Oona: " + cardsWithColor + " Token" + (cardsWithColor != 1 ? "s" : "") + " created");
        return true;
    }
}

