/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.o.OpalPalaceWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.common.CommanderPlaysCountWatcher;

class OpalPalaceEntersBattlefieldEffect
extends ReplacementEffectImpl {
    OpalPalaceEntersBattlefieldEffect() {
        super(Duration.EndOfGame, Outcome.BoostCreature, false);
        this.staticText = "If you spend this mana to cast your commander, it enters with a number of +1/+1 counters on it equal to the number of times it's been cast from the command zone this game";
    }

    private OpalPalaceEntersBattlefieldEffect(OpalPalaceEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        OpalPalaceWatcher watcher = (OpalPalaceWatcher)game.getState().getWatcher(OpalPalaceWatcher.class, source.getSourceId());
        return watcher != null && watcher.manaUsedToCastCommanderPart(event.getTargetId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        CommanderPlaysCountWatcher watcher;
        int castCount;
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent != null && (castCount = (watcher = (CommanderPlaysCountWatcher)game.getState().getWatcher(CommanderPlaysCountWatcher.class)).getPlaysCount(permanent.getId())) > 0) {
            permanent.addCounters(CounterType.P1P1.createInstance(castCount), source.getControllerId(), source, game);
        }
        return false;
    }

    public OpalPalaceEntersBattlefieldEffect copy() {
        return new OpalPalaceEntersBattlefieldEffect(this);
    }
}

