/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class OpalTitanBecomesCreatureEffect
extends ContinuousEffectImpl {
    OpalTitanBecomesCreatureEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BecomeCreature);
        this.staticText = "it becomes a 4/4 Giant creature with protection from each of that spell's colors.";
        this.addDependencyType(DependencyType.BecomeCreature);
    }

    private OpalTitanBecomesCreatureEffect(OpalTitanBecomesCreatureEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public OpalTitanBecomesCreatureEffect copy() {
        return new OpalTitanBecomesCreatureEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
        Spell creatureSpellCast = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (creatureSpellCast != null && creatureSpellCast.getColor(game).hasColor()) {
            game.getState().setValue("opalTitanColor" + source.getSourceId(), (Object)creatureSpellCast.getColor(game));
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent != null) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.removeAllCardTypes(game);
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    permanent.removeAllSubTypes(game);
                    permanent.addSubType(game, new SubType[]{SubType.GIANT});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    if (game.getState().getValue("opalTitanColor" + source.getSourceId()) == null) break;
                    for (ObjectColor color : ((ObjectColor)game.getState().getValue("opalTitanColor" + source.getSourceId())).getColors()) {
                        if (permanent.getAbilities().contains((Ability)ProtectionAbility.from((ObjectColor)color))) continue;
                        permanent.addAbility((Ability)ProtectionAbility.from((ObjectColor)color), source.getSourceId(), game);
                    }
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(4);
                    permanent.getToughness().setModifiedBaseValue(4);
                }
            }
            return true;
        }
        this.discard();
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }
}

