/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.LibrarySearchedEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class OppositionAgentReplacementEffect
extends ReplacementEffectImpl {
    OppositionAgentReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "While an opponent is searching their library, they exile each card they find. You may play those cards for as long as they remain exiled, and you may spend mana as though it were mana of any color to cast them";
    }

    private OppositionAgentReplacementEffect(OppositionAgentReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        LibrarySearchedEvent se = (LibrarySearchedEvent)event;
        if (!event.getTargetId().equals(event.getPlayerId())) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(event.getTargetId());
        if (targetPlayer == null || controller == null) {
            return false;
        }
        Set<Card> cardsToExile = se.getSearchedTarget().getTargets().stream().map(id -> targetPlayer.getLibrary().getCard(id, game)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (cardsToExile.isEmpty()) {
            return false;
        }
        targetPlayer.moveCards(cardsToExile, Zone.EXILED, source, game);
        cardsToExile.removeIf(card -> game.getState().getZone(card.getId()) != Zone.EXILED);
        if (cardsToExile.isEmpty()) {
            return false;
        }
        cardsToExile.forEach(card -> se.getSearchedTarget().remove(card.getId()));
        for (Card card2 : cardsToExile) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card2, (boolean)false, (Duration)Duration.EndOfGame, (boolean)true, (UUID)controller.getId(), null);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LIBRARY_SEARCHED;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent oppositionAgent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        return oppositionAgent != null && controller != null && game.isOpponent(controller, event.getPlayerId());
    }

    public OppositionAgentReplacementEffect copy() {
        return new OppositionAgentReplacementEffect(this);
    }
}

