/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OracleEnVecCantAttackRestrictionEffect
extends RestrictionEffect {
    OracleEnVecCantAttackRestrictionEffect() {
        super(Duration.Custom);
        this.staticText = "{this} can't attack.";
    }

    private OracleEnVecCantAttackRestrictionEffect(OracleEnVecCantAttackRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public OracleEnVecCantAttackRestrictionEffect copy() {
        return new OracleEnVecCantAttackRestrictionEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source) != null && this.getTargetPointer().getFirst(game, source).equals(permanent.getId());
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent perm = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (perm != null) {
            this.setStartingControllerAndTurnNum(game, perm.getControllerId(), game.getActivePlayerId());
        } else {
            this.discard();
        }
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game);
    }
}

