/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.o.OracleEnVecCantAttackRestrictionEffect;
import mage.cards.o.OracleEnVecDelayedTriggeredAbility;
import mage.cards.o.OracleEnVecMustAttackRequirementEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OracleEnVecEffect
extends OneShotEffect {
    OracleEnVecEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent chooses any number of creatures they control. During that player's next turn, the chosen creatures attack if able, and other creatures can't attack. At the beginning of that turn's end step, destroy each of the chosen creatures that didn't attack this turn";
    }

    private OracleEnVecEffect(OracleEnVecEffect effect) {
        super((OneShotEffect)effect);
    }

    public OracleEnVecEffect copy() {
        return new OracleEnVecEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, Integer.MAX_VALUE);
        target.withNotTarget(true);
        if (!target.choose(Outcome.Neutral, opponent.getId(), source.getSourceId(), source, game)) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), opponent.getId(), source, game)) {
            Object effect;
            if (target.getTargets().contains(permanent.getId())) {
                effect = new OracleEnVecMustAttackRequirementEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
                continue;
            }
            effect = new OracleEnVecCantAttackRestrictionEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OracleEnVecDelayedTriggeredAbility(game.getTurnNum(), target.getTargets()), source);
        return true;
    }
}

